/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.pascal;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.pascal.PascalFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;

public class PascalFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int ENTRY_SIZE = 26;
    private static final String TEXTFILE = "TEXT";
    private static final String CODEFILE = "CODE";
    private static final String DATAFILE = "DATA";
    private static final String[] filetypes = new String[]{"xdskfile", "CODE", "TEXT", "INFO", "DATA", "GRAF", "FOTO", "securedir"};

    public PascalFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static PascalFormatDisk[] create(String filename, String volumeName, ImageOrder imageOrder) {
        PascalFormatDisk disk = new PascalFormatDisk(filename, imageOrder);
        disk.format();
        disk.setDiskName(volumeName);
        return new PascalFormatDisk[]{disk};
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("PascalFormatDisk.Pascal");
    }

    @Override
    public List<FileEntry> getFiles() {
        ArrayList<FileEntry> list = new ArrayList<FileEntry>();
        byte[] directory = this.readDirectory();
        int entrySize = 26;
        int count = AppleUtil.getWordValue(directory, 16);
        int offset = entrySize;
        for (int i = 0; i < count; ++i) {
            byte[] entry = new byte[entrySize];
            System.arraycopy(directory, offset, entry, 0, entry.length);
            list.add(new PascalFileEntry(entry, this));
            offset += entrySize;
        }
        return list;
    }

    public List<PascalFileEntry> getDirectory() {
        ArrayList<PascalFileEntry> list = new ArrayList<PascalFileEntry>();
        byte[] directory = this.readDirectory();
        int count = AppleUtil.getWordValue(directory, 16);
        int offset = 0;
        for (int i = 0; i <= count; ++i) {
            byte[] entry = new byte[26];
            System.arraycopy(directory, offset, entry, 0, entry.length);
            list.add(new PascalFileEntry(entry, this));
            offset += 26;
        }
        return list;
    }

    public void putDirectory(List list) {
        byte[] directory = new byte[2048];
        int count = list.size();
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            byte[] entry = ((PascalFileEntry)list.get(i)).toBytes();
            System.arraycopy(entry, 0, directory, offset, entry.length);
            offset += 26;
        }
        this.writeDirectory(directory);
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        int count = 0;
        int index = 0;
        int max = 0;
        int last = 0;
        int first = 0;
        int free = 0;
        List<PascalFileEntry> dir = this.getDirectory();
        count = dir.size();
        for (int i = 1; i < count; ++i) {
            last = dir.get(i - 1).getLastBlock();
            first = dir.get(i).getFirstBlock();
            free = first - last;
            if (free <= max) continue;
            max = free;
            index = i;
        }
        last = dir.get(count - 1).getLastBlock();
        first = this.getBlocksOnDisk();
        free = first - last;
        if (free > max) {
            max = free;
            index = count;
        }
        if (free > 0 && count < 78) {
            PascalFileEntry volEntry = dir.get(0);
            volEntry.setFileCount(count);
            dir.set(0, volEntry);
            dir.add(index, new PascalFileEntry(new byte[26], this));
            PascalFileEntry entry = dir.get(index);
            first = dir.get(index - 1).getLastBlock();
            entry.setFirstBlock(first);
            entry.setLastBlock(first + max);
            entry.setFiletype("data");
            entry.setFilename("x");
            entry.setBytesUsedInLastBlock(512);
            entry.setModificationDate(new Date());
            entry.setEntryIndex(index);
            dir.set(index, entry);
            this.putDirectory(dir);
            return entry;
        }
        throw new DiskFullException(this.textBundle.get("PascalFormatDisk.DiskFull"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return true;
    }

    public byte[] readDirectory() {
        byte[] directory = new byte[2048];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.readBlock(2 + i), 0, directory, i * 512, 512);
        }
        return directory;
    }

    public void writeDirectory(byte[] directory) {
        if (directory == null || directory.length != 2048) {
            throw new IllegalArgumentException(this.textBundle.get("PascalFormatDisk.InvalidPascalDirectory"));
        }
        for (int i = 0; i < 4; ++i) {
            byte[] block = new byte[512];
            System.arraycopy(directory, i * 512, block, 0, 512);
            this.writeBlock(2 + i, block);
        }
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeBlocks() * 512;
    }

    public int getFreeBlocks() {
        List<FileEntry> files = this.getFiles();
        int blocksFree = this.getBlocksOnDisk() - 6;
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PascalFileEntry entry = (PascalFileEntry)files.get(i);
                blocksFree -= entry.getBlocksUsed();
            }
        }
        return blocksFree;
    }

    protected byte[] getVolumeEntry() {
        byte[] block = this.readBlock(2);
        byte[] entry = new byte[26];
        System.arraycopy(block, 0, entry, 0, entry.length);
        return entry;
    }

    public int getBlocksOnDisk() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 14);
    }

    public int getFilesOnDisk() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 16);
    }

    public int getFirstBlock() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 18);
    }

    public Date getLastAccessDate() {
        return AppleUtil.getPascalDate(this.getVolumeEntry(), 18);
    }

    public Date getMostRecentDateSetting() {
        return AppleUtil.getPascalDate(this.getVolumeEntry(), 20);
    }

    @Override
    public int getUsedSpace() {
        return this.getUsedBlocks() * 512;
    }

    public int getUsedBlocks() {
        List<FileEntry> files = this.getFiles();
        int blocksUsed = 6;
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PascalFileEntry entry = (PascalFileEntry)files.get(i);
                blocksUsed += entry.getBlocksUsed();
            }
        }
        return blocksUsed;
    }

    @Override
    public String getDiskName() {
        return AppleUtil.getPascalString(this.readBlock(2), 6) + ":";
    }

    @Override
    public void setDiskName(String volumeName) {
        byte[] directory = this.readDirectory();
        AppleUtil.setPascalString(directory, 6, volumeName.toUpperCase(), 7);
        this.writeDirectory(directory);
    }

    @Override
    public int[] getBitmapDimensions() {
        return null;
    }

    @Override
    public int getBitmapLength() {
        return this.getBlocksOnDisk();
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new PascalDiskUsage();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), this.getBlocksOnDisk()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.FilesOnDisk"), this.getFilesOnDisk()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.LastAccessDate"), this.getLastAccessDate()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.MostRecentDateSetting"), this.getMostRecentDateSetting()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.FirstBlock"), this.getFirstBlock()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.VolumeDate"), this.getLastAccessDate()));
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 8, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 8, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.BytesInLastBlock"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.FirstBlock"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.LastBlock"), 3, 3));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return false;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return true;
    }

    @Override
    public boolean canDeleteFile() {
        return true;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof PascalFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("PascalFormatDisk.IncorrectFileEntryError"));
        }
        PascalFileEntry pascalEntry = (PascalFileEntry)fileEntry;
        int firstBlock = pascalEntry.getFirstBlock();
        int lastBlock = pascalEntry.getLastBlock();
        byte[] fileData = new byte[pascalEntry.getSize()];
        int offset = 0;
        for (int block = firstBlock; block < lastBlock; ++block) {
            byte[] blockData = this.readBlock(block);
            if (block == lastBlock - 1) {
                System.arraycopy(blockData, 0, fileData, offset, pascalEntry.getBytesUsedInLastBlock());
            } else {
                System.arraycopy(blockData, 0, fileData, offset, blockData.length);
            }
            offset += blockData.length;
        }
        return fileData;
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        byte[] directory = this.readDirectory();
        AppleUtil.setWordValue(directory, 0, 0);
        AppleUtil.setWordValue(directory, 2, 6);
        AppleUtil.setWordValue(directory, 4, 0);
        int blocks = this.getImageOrder().getBlocksOnDevice();
        AppleUtil.setWordValue(directory, 14, blocks);
        AppleUtil.setWordValue(directory, 16, 0);
        AppleUtil.setWordValue(directory, 18, 0);
        AppleUtil.setPascalDate(directory, 20, new Date());
        this.writeDirectory(directory);
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        StringBuffer newName = new StringBuffer();
        if (!Character.isLetter(filename.charAt(0))) {
            newName.append('A');
        }
        for (int i = 0; newName.length() < 15 && i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '.') continue;
            newName.append(ch);
        }
        return newName.toString().toUpperCase().trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        String filetype = DATAFILE;
        int pos = filename.lastIndexOf(".");
        if (pos > 0) {
            String what = filename.substring(pos + 1);
            if ("txt".equalsIgnoreCase(what)) {
                filetype = TEXTFILE;
            } else if ("pas".equalsIgnoreCase(what)) {
                filetype = CODEFILE;
            }
        }
        return filetype;
    }

    @Override
    public String[] getFiletypes() {
        return filetypes;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return false;
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByBlock(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class PascalDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private BitSet bitmap = null;

        private PascalDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == -1 || this.location < PascalFormatDisk.this.getBlocksOnDisk() - 1;
        }

        @Override
        public void next() {
            if (this.bitmap == null) {
                this.bitmap = new BitSet(PascalFormatDisk.this.getBlocksOnDisk());
                for (int block = 6; block < PascalFormatDisk.this.getBlocksOnDisk(); ++block) {
                    this.bitmap.set(block);
                }
                for (PascalFileEntry pascalFileEntry : PascalFormatDisk.this.getFiles()) {
                    for (int block = pascalFileEntry.getFirstBlock(); block < pascalFileEntry.getLastBlock(); ++block) {
                        this.bitmap.clear(block);
                    }
                }
                this.location = 0;
            } else {
                ++this.location;
            }
        }

        @Override
        public boolean isFree() {
            return this.bitmap.get(this.location);
        }

        @Override
        public boolean isUsed() {
            return !this.bitmap.get(this.location);
        }
    }
}

